TextBlock OleAutoObjectEx fr pre-SP4

STATIC GLOBAL GUID_NULL is _WINGUID

CLASS OleAutoObjectEx Inherit OleAutoObject
	EXPORT cIID			as STRING		// Interface Id of the class
	EXPORT cClsId		as STRING     	// ClassId of the class (when it is a coclass)
	EXPORT cProgId		as STRING		// ProgId idem
   protect destroyCounter as int
   
METHOD __CreateFromIDispatch(lpIDispatch as ptr) as LOGIC PASCAL Class OleAutoObjectEx
	LOCAL sIID 				is _WINGUID
	LOCAL lpNewIDispatch as ptr
	LOCAL oDispatch		as cIDispatch
	LOCAL hResult			as LONG
	BEGIN SEQUENCE
		IF lpIDispatch != null_ptr
			IF SLen(self:cIID) > 0
				oDispatch := OBJECT(_cast, lpIDispatch)
				IF oDispatch != null_object   
					IF CreateGuidFromString(cIID, @sIID) .and. ! IsEqualGuid(@sIID, @GUID_NULL)
						hResult := oDispatch:QueryInterface(@sIID, @lpNewIDispatch)
						IF ( OleFailed(self:hResult) .and. lpNewIDispatch != null_ptr)
							BREAK
						ENDIF
						lpIDispatch := lpNewIDispatch
					ENDIF
					oDispatch:Release()
					oDispatch := null_object          
				ENDIF
			ENDIF
		ENDIF
		RETURN Super:__CreateFromIDispatch(lpIDispatch) 
	RECOVER
		if (oDispatch != null_object)
			oDispatch:Release()          
		ENDIF

	END
	RETURN FALSE
	  
METHOD Init(ObjID, uLcid, fNoFuncArray, fROTCheck) Class OleAutoObjectEx    
	destroyCounter := 0
	IF IsNil(ObjID) .and. SLen(self:cClsId) > 0
		ObjID := self:cClsId
	ENDIF
	Super:Init(ObjID, uLcid, fNoFuncArray, fROTCheck)
	IF SLen(self:cProgId) > 0
		self:atomObjName := String2Symbol(self:cProgId)
	ENDIF
	RETURN self       

