// Application : XSharp.Tools.SqlServer
// SQLServerConnection.prg , Created : 24.09.2022   18:30
// User : Wolfgang

using System.Data.SqlClient
using System.Data
using System.Collections
using System.Diagnostics
using System.Collections.Generic
using XSharp.Tools.SqlBase

begin namespace XSharp.Tools.SqlServer

class SqlServerConnection inherit System.Object implements ISQLConnection, IDisposable
	protect _oConnection 	as SqlConnection
	protect _lConnected 	as logic
	protect _cLastError		as string
	protect _oException		as Exception

constructor( cServer as string, cDatabaseName as string, cUser as string, cPassword as string )

	super()
	self:OpenConnection( cServer, cDatabaseName, cUser, cPassword )

	return

constructor()

    super()

    return

public property Connection as SqlConnection get _oConnection
public property Connected as logic get _lConnected
public property LastError as string get _cLastError
public property Exception as Exception get _oException

method Dispose() as void

	self:Close()

	return

public method BuildConnectionString( cServer as string, cDatabaseName as string, cUser as string, cPassword as string, cRole as string ) as string
	local cConnString			as string

	cConnString		:= SqlServerHelper.BuildConnectionString( cServer, cDatabaseName, cUser, cPassword, cRole )

	return cConnString

method Connect( ConnString as string ) as logic

    try

    _oConnection        := SqlConnection{}
    _oConnection:ConnectionString := ConnString
    _oConnection:Open()
    _lConnected         := self:IsConnectionOpen()

    catch oEx as Exception

    _lConnected         := false
    _cLastError			:= oEx:Message
    _oException			:= oEx
    Debug.WriteLine( oEx:Message )
	ErrorSys.InvokeExceptionHandler( oEx, ConnString )

    end try

    return _lConnected

method IsConnectionOpen() as logic pascal
    //local oState        as ConnectionState
    local lReturn       as logic

    lReturn := false
    if _oConnection != null_object
        if _oConnection:State == ConnectionState.Open
            lReturn := true
        endif
    endif

    return lReturn

method ExecuteStatement( cStatement as string ) as int
    local oCommand      as SqlCommand
    local nReturn       as int

    nReturn			:= -1

	try

    oCommand        := SqlCommand{ cStatement, _oConnection }
    nReturn         := oCommand:ExecuteNonQuery()

	catch oEx as Exception

    _cLastError			:= oEx:Message
    Debug.WriteLine( oEx:Message )
    _oException			:= oEx
	ErrorSys.InvokeExceptionHandler( oEx, cStatement )

	end try

    return nReturn

method Close() as void

   if _oConnection != null_object
       if _oConnection:State != ConnectionState.Closed
           _oConnection:Close()
       endif
       _oConnection         := null_object
       _lConnected          := false
   endif

return

method GetDataTable( cSelect as string ) as DataTable
	local oAdapter			as SqlDataAdapter
	local oDataSet			as DataSet
	local oDataTable		as DataTable

    oDataTable          := null_object

	try

	oAdapter            := SqlDataAdapter{ cSelect, self:Connection }
    oDataSet            := Dataset{}
    oAdapter:Fill( oDataSet )
    oDataTable          := oDataSet:Tables[0]
    oDataSet			:= null_object

	catch oEx as Exception

    _cLastError			:= oEx:Message
    Debug.WriteLine( oEx:Message )
    _oException			:= oEx
	ErrorSys.InvokeExceptionHandler( oEx, cSelect )

	end try

	return oDataTable

method OpenConnection( cServer as string, cDatabaseName as string, cUser as string, cPassword as string ) as logic
	local ConnString 	as string
	local lReturn		as logic

	ConnString 	:= self:BuildConnectionString( cServer, cDatabaseName, cUser, cPassword, "" )
	lReturn		:= self:Connect( ConnString )

	return lReturn

method OpenConnection( cServer as string, cDatabaseName as string, cUser as string, cPassword as string, cRole as string ) as logic
	local cConnString 	as string
	local lReturn		as logic

	cConnString 	:= self:BuildConnectionString( cServer, cDatabaseName, cUser, cPassword, cRole )
	lReturn			:= self:Connect( cConnString )

	return lReturn

end class

end namespace

