// Application : XSharp.Tools.SqlConnectionSample
// PersonDialog.Code.prg , Created : 09.10.2022   11:21
// User : Wolfgang




class PersonDialog inherit _PersonDialog
	protect _oPerson		as Person
	protect _lCanceled		as logic

constructor()

	super()
	self:Initialize()

	return

method Initialize() as logic

	oCancelButton:Click			+= CancelButtonClick
	oOkButton:Click				+= OKButtonClick

	return true

method FillData() as void

	if _oPerson != null
		oPersonName:Text		:= _oPerson:PersonName
		oCountry:Text			:= _oPerson:Country
	endif

	return

method OkButtonClick(sender as object , e as System.EventArgs) as void

	if _oPerson == null
		_oPerson			:= Person{}
	endif
	_oPerson:PersonName	:= oPersonName:Text:Trim()
	_oPerson:Country	:= oCountry:Text:Trim()
	_lCanceled			:= false
	self:Close()

	return

method CancelButtonClick(sender as object , e as System.EventArgs) as void

	_lCanceled					:= true
	self:Close()

	return

property Person as Person get _oPerson set _oPerson := value, self:FillData()
property Canceled as logic get _lCanceled

end class


