// Application : XSharp.Tools.SqlSample
// IniFile.prg , Created : 30.09.2022   15:46
// User : Wolfgang


using System
using System.Text
using System.Runtime.InteropServices
using System.IO
using System.Collections.Generic

begin namespace XSharp.Tools.SqlConnectionSample

class IniFile
	protect _cFileName 		as string
	protect _nStringLen		as int

#region Constructors

constructor( cFileName as string )

	self:Initialize()
	self:FileName 			:= cFileName

	return

#endregion

#region Static methods - Windows API imports

	[DllImport("kernel32.dll",CharSet:=CharSet.Ansi,EntryPoint:="GetPrivateProfileString")];
static method GetString(lpAppName as string, lpKeyName as string, lpDefault as string, lpBuffer as StringBuilder, nSize as dword, lpFileName as string) as dword pascal

	[DllImport("kernel32.dll",CharSet:=CharSet.Ansi,EntryPoint:="GetPrivateProfileString")];
static method GetString(lpAppName as string, lpKeyName as string, lpDefault as string, lpBuffer as byte[], nSize as dword, lpFileName as string) as dword pascal

	[DllImport("kernel32.dll",CharSet:=CharSet.Ansi,EntryPoint:="WritePrivateProfileString")];
static method WriteString(lpAppName as string, lpKeyname as string,lpString as string, lpFileName as string) as logic pascal

	[DllImport("kernel32.dll",CharSet:=CharSet.Auto,EntryPoint:="GetPrivateProfileInt")];
static method GetInt(lpAppName as string, lpKeyname as string,nDefault as int , lpFileName as string) as int pascal

	[DllImport("kernel32.dll",CharSet:=CharSet.Ansi,EntryPoint:="GetPrivateProfileSection")];
static method GetSection(lpAppName as string, lpszReturnBuffer as byte[], nSize as int, lpFileName as string) as logic pascal

	[DllImport("kernel32.dll",CharSet:=CharSet.Ansi,EntryPoint:="GetPrivateProfileSectionNamesA")];
static method GetPrivateProfileSectionNames ( lpszReturnBuffer as byte[], nSize as int, lpFileName as string ) as int pascal

#endregion

#region Private methods

private method Initialize() as logic

	_nStringLen			:= 8192

	return true

#endregion

#region public methods

public virtual method DeleteSection( cSection as string ) as void

	IniFile.WriteString( cSection, null, null, _cFileName )

	return

public virtual method GetString( cSection as string, cEntry as string ) as string
	local cReturn 		as string

	cReturn 			:= self:GetString( cSection, cEntry, "" )

	return cReturn

public virtual method GetString( cSection as string, cEntry as string, cDefault as string ) as string
	local cReturn 		as string
	local oReturn 		as System.Text.StringBuilder

	oReturn 			:= System.Text.StringBuilder{ _nStringLen }
	// GetPrivateProfileStringSB( cSection, cEntry, cDefault, oReturn, nMaxLen, _cFileName )
	IniFile.GetString( cSection, cEntry, cDefault, oReturn, dword( _nStringLen ), _cFileName )
	cReturn				:= oReturn:ToString()
	cReturn 			:= cReturn:Trim()
	oReturn 			:= null_object

	return cReturn

public virtual method GetStringCheck( cSection as string, cEntry as string, cDefault as string ) as string
	local cReturn		as string
	local cCheck		as string
	local cCompare		as string

	cReturn				:= self:GetString( cSection, cEntry, cDefault )
	if cReturn == cDefault
		cCompare			:= "$$" + cDefault
		cCheck				:= self:GetString( cSection, cEntry, cCompare )
		if cCheck == cCompare
			self:WriteString( cSection, cEntry, cDefault )
		endif
	endif

	return cReturn

public virtual method WriteString( cSection as string, cEntry as string, cValue as string ) as string

	IniFile.WriteString( cSection, cEntry, cValue, _cFileName )

	return cValue

public virtual method GetInt( cSection as string, cEntry as string, nDefault as int ) as int
	local nReturn as int
	local cValue as string

	cValue 				:= self:GetString( cSection, cEntry, nDefault:ToString() )
	nReturn 			:= System.Convert.ToInt32( cValue )

	return nReturn

public virtual method GetIntCheck( cSection as string, cEntry as string, nDefault as int ) as int
	local nReturn 		as int
	local cValue 		as string

	cValue 				:= self:GetStringCheck( cSection, cEntry, nDefault:ToString() )
	nReturn 			:= System.Convert.ToInt32( cValue )

	return nReturn

public virtual method WriteInt( cSection as string, cEntry as string, nValue as int ) as void

	IniFile.WriteString( cSection, cEntry, nValue:ToString(), self:FileName )

	return

public virtual method GetLogic( cSection as string, cEntry as string, lDefault as logic ) as logic
	local nValue 		as int
	local cValue 		as string
	local lReturn		as logic

	cValue 				:= self:GetString( cSection, cEntry, "" )
	if cValue == ""
		lReturn				:= lDefault
	else
		nValue				:= 0
		if Int32.TryParse( cValue, nValue ) == false
			nValue				:= 0
		endif
		if nValue == 0
			lReturn				:= false
		else
			lReturn				:= true
		endif
	endif

	return lReturn

public virtual method GetLogicCheck( cSection as string, cEntry as string, lDefault as logic ) as logic
	local cValue 		as string
	local lReturn		as logic

	cValue 				:= self:GetString( cSection, cEntry, "" )
	if cValue == ""
		lReturn				:= lDefault
		self:WriteLogic( cSection, cEntry, lDefault )
	else
		lReturn				:= self:GetLogic( cSection, cEntry, lDefault )
	endif

	return lReturn

public virtual method GetSectionNames() as string[]
	local aBuffer		as byte[]
	local cBuffer		as string
	local aSectionNames	as string[]
	local nPos			as int

	aBuffer			:= byte[]{ 10240 }
	IniFile.GetPrivateProfileSectionNames( aBuffer, aBuffer:Length, _cFileName )
	cBuffer			:= System.Text.Encoding.Default:GetString( aBuffer )
	nPos			:= cBuffer:IndexOf( e"\0\0" )
	if nPos == 0
		aSectionNames	:= string[]{ 0 }		// no section names
	else
		aSectionNames	:= cBuffer:Substring( 0, nPos ):Split( '\0' )
	endif

	return aSectionNames

public virtual method WriteLogic( cSection as string, cEntry as string, lValue as logic ) as void
	local cValue			as string

	if lValue
		cValue				:= "1"
	else
		cValue				:= "0"
	endif

	IniFile.WriteString( cSection, cEntry, cValue, self:FileName )

	return

#endregion

#region Public properties

public virtual property FileName as string
	get
		return _cFileName
	end get
	set
		local cFileName			as string
		local cPath				as string
		cFileName			:= value
		if Path.GetDirectoryName( cFileName ) == String.Empty
			cPath				:= Environment.GetFolderPath( Environment.SpecialFolder.ApplicationData )
			cFileName			:= Path.Combine( cPath, cFileName )
		endif
		_cFileName			:= cFileName
	end set
end property
public virtual property StringLen as int
	get
		return _nStringLen
	end get
	set
		_nStringLen			:= value
	end set
end property

#endregion

end class

end namespace

