// Application : XSharp.Tools.SqlConnectionSample
// Form1.Code.prg , Created : 09.10.2022   09:36
// User : Wolfgang

using System.Data
using System.Windows.Forms
using System.ComponentModel
// using System.Collections.ObjectModel
using XSharp.Tools.SqlBase
using XSharp.Tools.SQLite

class BasicForm inherit _BasicForm
	protect _oData			as BindingList<Person>	 // ObservableCollection<Person> WPF only
	protect _oIniFile		as IniFile

constructor()

	super()
	self:Initialize()

	return

method Initialize() as logic

	_oIniFile				:= IniFile{ System.IO.Path.Combine( AppDomain.CurrentDomain:BaseDirectory, "XSharp.Tools.SQLConnectionSample.ini" ) }

	_oData					:= BindingList<Person>{}
	oGrid:SelectionMode		:= DataGridViewSelectionMode.FullRowSelect
	oGrid:AllowUserToAddRows	:= false
	oGrid:AllowUserToDeleteRows	:= false
	oGrid:ReadOnly			:= true
	oGrid:DataSource		:= _oData
	oRemoveButton:Click		+= RemoveButtonClick
	oEditButton:Click		+= EditButtonClick
	oReadButton:Click 		+= ReadButtonClick
	oAddButton:Click 		+= AddButtonClick
	oCloseButton:Click 		+= CloseButtonClick
	oDatabase:Text			:= _oIniFile:GetString( "Settings", "Database", System.IO.Path.Combine( AppDomain.CurrentDomain:BaseDirectory, "Summit.db" ) )

    return true

method RemoveButtonClick(sender as object , e as System.EventArgs) as void
	local oPerson			as Person
	local cStatement		as string

	oPerson					:= self:SelectedPerson()
	if oPerson != null .and. ! String.IsNullOrEmpty( oPerson:ID )
		cStatement				:= String.Format( "delete from person where id = '{0}'", oPerson:ID )
		self:ExecuteStatement( cStatement )
		self:ReadData()
	endif

	return

method EditButtonClick(sender as object , e as System.EventArgs) as void
	local oPerson			as Person
	local oDlg				as PersonDialog
	local oValues			as ValuesList

	oPerson					:= self:SelectedPerson()
	oDlg					:= PersonDialog{}
	oDlg:Person				:= oPerson
	oDlg:ShowDialog( self )
	if oDlg:Canceled == false
		oValues					:= ValuesList{}
		oValues:AddValue( "PersonName", oPerson:PersonName )
		oValues:AddValue( "Country", oPerson:Country )
		self:ExecuteStatement( SQLiteHelper.CreateUpdateString( "person", oValues, String.Format( "where id = '{0}'", oPerson:Id ) ) )
		self:ReadData()
	endif

	return

method ReadButtonClick(sender as object , e as System.EventArgs) as void

	self:ReadData()

	return

method ReadData() as void
	local oDataTable		as DataTable
	local oPerson			as Person

	oDataTable				:= self:GetDataTable( "select * from person order by personname" )
	if oDataTable == null
		self:InitDatabase()
		oDataTable				:= self:GetDataTable( "select * from person order by personname" )
	endif
	if oDataTable != null
		_oData:Clear()
		foreach oRow as DataRow in oDataTable:Rows
			oPerson					:= Person{ oRow }
			_oData:Add( oPerson )
		next

	endif

	return

method AddButtonClick(sender as object , e as System.EventArgs) as void
	local oPerson			as Person
	local oDlg				as PersonDialog
	local oValues			as ValuesList

	oPerson					:= Person{}
	oDlg					:= PersonDialog{}
	oDlg:Person				:= oPerson
	oDlg:ShowDialog( self )
	if oDlg:Canceled == false
		oValues					:= ValuesList{}
		oValues:AddValue( "PersonName", oPerson:PersonName )
		oValues:AddValue( "Country", oPerson:Country )
		oValues:AddValue( "Id", Guid.NewGuid():ToString() )
		self:ExecuteStatement( SQLiteHelper.CreateInsertString( "person", oValues ) )
		self:ReadData()
	endif

	return

method CloseButtonClick(sender as object , e as System.EventArgs) as void

	self:Close()

	return

protected method SelectedPerson() as Person
	local oSelected			as DataGridViewSelectedRowCollection
	local oPerson			as Person

	oSelected				:= oGrid:SelectedRows
	if oSelected != null .and. oSelected:Count > 0 .and. oSelected[0]:DataBoundItem is Person
		oPerson					:= ( Person ) oSelected[0]:DataBoundItem
	else
		oPerson					:= null
	endif

	return oPerson

protected method GetDataTable( cSelect as string ) as DataTable
	local oReturn			as DataTable
	local oConn				as ISQLConnection

	oConn				:= self:GetConnection()
	if oConn != null
		oReturn				:= oConn:GetDataTable( cSelect )
		oConn:Close()
	else
		oConn				:= null
		oReturn				:= null
	endif

    return oReturn

protected method ExecuteStatement( cStmt as string ) as int
	local nReturn			as int
	local oConn				as ISQLConnection

	oConn				:= self:GetConnection()
	if oConn != null
		nReturn				:= oConn:ExecuteStatement( cStmt )
		oConn:Close()
	else
		nReturn				:= -1
		oConn				:= null
	endif

	return nReturn

protected method GetConnection() as ISQLConnection
	local cDatabase			as string
	local oConn				as SQLiteConn

	cDatabase			:= oDatabase:Text:Trim()
	oConn				:= SQLiteConn{ "", cDatabase, "", "" }
	if oConn:Connected == false
		self:ErrBox( oConn:LastError )
		oConn				:= null
	endif

	return oConn

protected method InitDatabase() as void
	local oConn				as SQLiteConn
	local cCreate			as string
	local oValues			as ValuesList

	oConn				:= ( SQLiteConn ) self:GetConnection()
	if oConn != null
		if oConn:ExistsTable( "person" ) == false
			text to cCreate
				create table person (
					id varchar(36),
					personname  varchar(254),
					country varchar(254)
					)
			endtext
			oConn:ExecuteStatement( cCreate )

			oValues			:= ValuesList{}
			oValues:AddValue( "personname", "Robert" )
			oValues:AddValue( "country", "The Netherlands" )
			oValues:AddValue( "id", Guid.NewGuid():ToString() )
			oConn:ExecuteStatement( SQLiteHelper.CreateInsertString( "person", oValues ) )

			oValues			:= ValuesList{}
			oValues:AddValue( "personname", "Fabrice" )
			oValues:AddValue( "country", "France" )
			oValues:AddValue( "id", Guid.NewGuid():ToString() )
			oConn:ExecuteStatement( SQLiteHelper.CreateInsertString( "person", oValues ) )

			oValues			:= ValuesList{}
			oValues:AddValue( "personname", "Nikos" )
			oValues:AddValue( "country", "Greece" )
			oValues:AddValue( "id", Guid.NewGuid():ToString() )
			oConn:ExecuteStatement( SQLiteHelper.CreateInsertString( "person", oValues ) )

			oValues			:= ValuesList{}
			oValues:AddValue( "personname", "Chris" )
			oValues:AddValue( "country", "Greece" )
			oValues:AddValue( "id", Guid.NewGuid():ToString() )
			oConn:ExecuteStatement( SQLiteHelper.CreateInsertString( "person", oValues ) )

			oConn:Close()
		endif
	endif


protected method ErrBox( cMessage as string ) as void

	MessageBox.Show( self, cMessage, "Error", MessageBoxButtons.OK, MessageBoxIcon.Error )

	return

end class
