// Application : XSharp.Tools.SqlBase
// StringExtensions.prg , Created : 24.09.2022   16:04
// User : Wolfgang

using System.Collections.Generic


begin namespace XSharp.Tools.SqlBase

class StringExtensions

constructor()

	return

static method FixUTF2Ansi( self cString as string ) as string
	local oReplace			as Dictionary<string,string>

	oReplace				:= Dictionary<string,string>{}
	oReplace:Add( e"\u2013", "-" )		//  	 	En dash 	0903
	oReplace:Add( e"\u2014", "-" )		//  	 	Em dash 	0904
	oReplace:Add( e"\u2015", "-" )		//  	- 	Horizontal bar 	0905
	oReplace:Add( e"\u2017", "=" )		//  	= 	Double low line 	0906
	oReplace:Add( e"\u2018", "'" )		//  	 	Left single quotation mark 	0907
	oReplace:Add( e"\u2019", "'" )		//  	 	Right single quotation mark 	0908
	oReplace:Add( e"\u201A", "'" )		//  	 	Single low-9 quotation mark 	0909
	oReplace:Add( e"\u201B", "'" )		//  	' 	Single high-reversed-9 quotation mark 	0910
	oReplace:Add( e"\u201C", e"\"" )	//  	 	Left double quotation mark 	0911
	oReplace:Add( e"\u201D", e"\"" )	//  	 	Right double quotation mark 	0912
	oReplace:Add( e"\u201E", e"\"" )	//  	 	Double low-9 quotation mark 	0913
	oReplace:Add( e"\u2020", "+" )		//  	 	Dagger 	0914
	oReplace:Add( e"\u2021", "+" )		//  	 	Double dagger 	0915
	oReplace:Add( e"\u2022", "*" )		//  	 	Bullet 	0916
	oReplace:Add( e"\u2026", ".." )		//  	 	Horizontal ellipsis 	0917
	oReplace:Add( e"\u2030", "0/00" )	//  	 	Per mille sign 	0918
	oReplace:Add( e"\u2032", "'" )		//  	' 	Prime 	0919
	oReplace:Add( e"\u2033", e"\"" )	//  	" 	Double prime 	0920
	oReplace:Add( e"\u2039", "<" )		//  	 	Single left-pointing angle quotation mark 	0921
	oReplace:Add( e"\u203A", ">" )		//  	 	Single right-pointing angle quotation mark 	0922
	oReplace:Add( e"\u203C", "??" )		//  	? 	Double exclamation mark 	0923
	oReplace:Add( e"\u203E", "-" )		//  	? 	Overline 	0924
	oReplace:Add( e"\u2044", "/" )		//  	/ 	Fraction slash 	0925
	oReplace:Add( e"\u204A", "7" )		//  	? 	Tironian et sign 	0926
	oReplace:Add( e"\u04D2", "" )		//  	? 	cyrillic capital letter A with diaresis (U+04D2)
	oReplace:Add( e"\u04D3", "" )		//  	? 	cyrillic small letter A with diaresis (U+04D3)
	oReplace:Add( e"\u04E6", "" )		//  	? 	cyrillic capital letter O with diaresis (U+04E6)
	oReplace:Add( e"\u04E7", "" )		//  	? 	cyrillic small letter O with diaresis (U+04E7)
	oReplace:Add( e"a\u0308", "a" )		//  	? 	small a with following diaresis
	oReplace:Add( e"o\u0308", "" )		//  	? 	small o with following diaresis
	oReplace:Add( e"u\u0308", "u" )		//  	? 	small u with following diaresis
	oReplace:Add( e"A\u0308", "" )		//  	? 	capital A with following diaresis
	oReplace:Add( e"O\u0308", "" )		//  	? 	capital O with following diaresis
	oReplace:Add( e"U\u0308", "" )		//  	? 	capital U with following diaresis

	foreach cU as string in oReplace:Keys
		if cString:Contains( cU )
			cString			:= cString:Replace( cU, oReplace[cU] )
			// System.Console.WriteLine( String.Format( "Replaced {0} with {1}", cU, oReplace[cU] ) )
		endif
	next

	return cString


end class

end namespace

