
using System.Text
using System.IO
using System.Diagnostics

begin namespace XSharp.Tools.SqlBase

public delegate ExceptionHandler( oEx as Exception, cSuppInfo as string ) as ProcessExceptionResult

public enum ProcessExceptionResult
	member None
	member Ok
	member Cancel
	member Abort
	member Retry
	member Ignore
	member Yes
	member No
end enum

class ErrorSys
	static protect _oExceptionHandler			as ExceptionHandler


static method SetExceptionHandler( oHandler as ExceptionHandler ) as void

	ErrorSys:_oExceptionHandler		:= oHandler

	return

static method InvokeExceptionHandler( oEx as Exception, cSuppInfo as string ) as ProcessExceptionResult
	local oResult				as ProcessExceptionResult

	if ErrorSys._oExceptionHandler != null
		oResult				:= ErrorSys._oExceptionHandler:Invoke( oEx, cSuppInfo )
	else
		oResult				:= ProcessExceptionResult.Ok
	endif

	return oResult

end class

end namespace

