// Application : XSharp.Tools.SQLite
// SQLiteConn.prg , Created : 24.09.2022   17:41
// User : Wolfgang

using System.Data.SQLite
using System.Data
using System.Collections
using System.Diagnostics
using System.Collections.Generic
using XSharp.Tools.SqlBase

begin namespace XSharp.Tools.SQLite

class SQLiteConn inherit System.Object implements ISQLConnection, IDisposable
	protect _oConnection 	as System.Data.SQLite.SQLiteConnection
	protect _lConnected 	as logic
	protect _cLastError		as string

constructor( cServer as string, cDatabaseName as string, cUser as string, cPassword as string )

	super()
	self:OpenConnection( cServer, cDatabaseName, cUser, cPassword )

	return

constructor()

    super()

    return

public property Connection as System.Data.SQLite.SQLiteConnection get _oConnection
public property Connected as logic get _lConnected
public property LastError as string get _cLastError

method Dispose() as void

	self:Close()

	return

public method BuildConnectionString( cServer as string, cDatabaseName as string, cUser as string, cPassword as string, cRole as string ) as string
	local cConnString			as string

	cConnString		:= SQLiteHelper.BuildConnectionString( cServer, cDatabaseName, cUser, cPassword, cRole )

	return cConnString

method Connect( ConnString as string ) as logic

    try

    _oConnection        := SQLiteConnection{}
    _oConnection:ConnectionString := ConnString
    _oConnection:Open()
    _lConnected         := self:IsConnectionOpen()

    catch oEx as Exception

    _lConnected         := false
    _cLastError			:= oEx:Message
    Debug.WriteLine( oEx:Message )
	ErrorSys.InvokeExceptionHandler( oEx, ConnString )

    end try

    return _lConnected

method IsConnectionOpen() as logic pascal
    local lReturn       as logic

    lReturn := false
    if _oConnection != null_object
        if _oConnection:State == ConnectionState.Open
            lReturn := true
        endif
    endif

    return lReturn

method ExecuteStatement( cStatement as string ) as int
    local oCommand      as SQLiteCommand
    local nReturn       as int

    oCommand        := SQLiteCommand{ cStatement, _oConnection }
    nReturn         := oCommand:ExecuteNonQuery()

    return nReturn

method Close() as void

   if _oConnection != null_object
       if _oConnection:State != ConnectionState.Closed
           _oConnection:Close()
       endif
       _oConnection         := null_object
       _lConnected          := false
   endif

return

method GetDataTable( cSelect as string ) as DataTable
	local oAdapter			as SQLiteDataAdapter
	local oDataSet			as DataSet
	local oDataTable		as DataTable

    oDataTable          := null_object

	try

	oAdapter            := SQLiteDataAdapter{ cSelect, self:Connection }
    oDataSet            := Dataset{}
    oAdapter:Fill( oDataSet )
    oDataTable          := oDataSet:Tables[0]
    oDataSet			:= null_object

	catch oEx as Exception

    _cLastError			:= oEx:Message
    Debug.WriteLine( oEx:Message )
	ErrorSys.InvokeExceptionHandler( oEx, cSelect )

	end try

	return oDataTable

method OpenConnection( cServer as string, cDatabaseName as string, cUser as string, cPassword as string ) as logic
	local ConnString 	as string
	local lReturn		as logic

	ConnString 	:= self:BuildConnectionString( cServer, cDatabaseName, cUser, cPassword, "" )
	lReturn		:= self:Connect( ConnString )

	return lReturn

method OpenConnection( cServer as string, cDatabaseName as string, cUser as string, cPassword as string, cRole as string ) as logic
	local cConnString 	as string
	local lReturn		as logic

	cConnString 	:= self:BuildConnectionString( cServer, cDatabaseName, cUser, cPassword, cRole )
	lReturn			:= self:Connect( cConnString )

	return lReturn

method ExistsTable( cTableName as string ) as logic
	local oTable		as DataTable
	local cSelect		as string
	local oRow			as DataRow
	local lReturn		as logic
	local nCount		as int

	lReturn				:= false
	cSelect				:= String.Format( "select count( distinct tbl_name ) as tablecount from sqlite_master where type = 'table' and tbl_name = '{0}'", cTableName )
	oTable				:= self:GetDataTable( cSelect )
	if oTable != null .and. oTable:Rows:Count > 0
		oRow				:= oTable:Rows[0]
		nCount				:= oRow:GetInt( "tablecount" )
		if nCount > 0
			lReturn				:= true
		endif
	endif
	oTable:Clear()

	return lReturn

method GetUserTables() as List<string>
	local oList			as List<string>
	local oTables		as DataTable
	local cSelect		as string

	cSelect				:= "select distinct tbl_name as tablename from sqlite_master where type = 'table' order by tbl_name"
	oTables				:= self:GetDataTable( cSelect )
	oList				:= List<string>{}
	if oTables != null
		foreach oRow as DataRow in oTables:Rows
			oList:Add( ( string ) oRow:Item["tablename"] )
		next
	endif
	oTables:Clear()

	return oList


end class

end namespace

