// Application : XSharp.Tools.Oracle
// OraConnection.prg , Created : 24.09.2022   16:26
// User : Wolfgang

using Oracle.ManagedDataAccess.Client
using System.Data
using System.Collections
using System.Diagnostics
using System.Collections.Generic
using XSharp.Tools.SqlBase

begin namespace XSharp.Tools.Oracle

class OraConnection inherit System.Object implements ISQLConnection, IDisposable
	protect _oConnection 	as OracleConnection
	protect _lConnected 	as logic
	protect _cLastError		as string
	protect _cSchema		as string

#region constructors

constructor( cServer as string, cDatabaseName as string, cUser as string, cPassword as string )

	super()
	self:OpenConnection( cServer, cDatabaseName, cUser, cPassword )
	self:Initialize()

	return

constructor()

    super()
	self:Initialize()

    return

method Initialize() as logic

	return true

#endregion
#region public properties

public property Connection as OracleConnection get _oConnection
public property Connected as logic get _lConnected
public property LastError as string get _cLastError
public property Schema as string get _cSchema set _cSchema := value

#endregion
#region Public methods

method Dispose() as void

	self:Close()

	return

public method BuildConnectionString( cServer as string, cDatabaseName as string, cUser as string, cPassword as string, cRole as string ) as string
	local cConnString			as string

	cConnString			:= OraHelper.BuildConnectionString( cServer, cDatabaseName, cUser, cPassword, cRole )

	return cConnString

method Connect( cConnString as string ) as logic

    try

    _oConnection        := OracleConnection{}
    _oConnection:ConnectionString := cConnString
    _oConnection:Open()
    _lConnected         := self:IsConnectionOpen()

    catch oEx as Exception

    _lConnected         := false
    _cLastError			:= oEx:Message
	oEx:Data:Add( "ConnectionString", cConnString )
    Debug.WriteLine( oEx:Message )
	ErrorSys.InvokeExceptionHandler( oEx, cConnString )

    end try

    return _lConnected

method IsConnectionOpen() as logic pascal
    //local oState        as ConnectionState
    local lReturn       as logic

    lReturn := false
    if _oConnection != null_object
        if _oConnection:State == ConnectionState.Open
            lReturn := true
        endif
    endif

    return lReturn

method ExecuteStatement( cStatement as string ) as int
    local oCommand      as OracleCommand
    local nReturn       as int

    nReturn			:= -1

    try

    oCommand        := OracleCommand{ cStatement, _oConnection }
    nReturn         := oCommand:ExecuteNonQuery()

    catch oEx as Exception

	oEx:Data:Add( "Statement", cStatement )
    _cLastError		:= oEx:Message + e"\r\n" + cStatement
    Debug.WriteLine( oEx:Message )
	ErrorSys.InvokeExceptionHandler( oEx, cStatement )

    end try

    return nReturn

method Close() as void

   if _oConnection != null_object
       if _oConnection:State != ConnectionState.Closed
           _oConnection:Close()
       endif
       _oConnection         := null_object
       _lConnected          := false
   endif

return

method GetDataTable( cSelect as string ) as DataTable
	local oAdapter			as OracleDataAdapter
	local oDataSet			as DataSet
	local oDataTable		as DataTable

    oDataTable          := null_object

	try

	oAdapter            := OracleDataAdapter{ cSelect, self:Connection }
    oDataSet            := Dataset{}
    oAdapter:Fill( oDataSet )
    oDataTable          := oDataSet:Tables[0]
    oDataSet			:= null_object

	catch oEx as Exception

    _cLastError			:= oEx:Message
	oEx:Data:Add( "Select", cSelect )
    Debug.WriteLine( oEx:Message )
	ErrorSys.InvokeExceptionHandler( oEx, cSelect )

	end try

	return oDataTable

method OpenConnection( cServer as string, cDatabaseName as string, cUser as string, cPassword as string ) as logic
	local ConnString 	as string
	local lReturn		as logic

	ConnString 	:= self:BuildConnectionString( cServer, cDatabaseName, cUser, cPassword, "" )
	lReturn		:= self:Connect( ConnString )

	return lReturn

method OpenConnection( cServer as string, cDatabaseName as string, cUser as string, cPassword as string, cRole as string ) as logic
	local cConnString 	as string
	local lReturn		as logic

	cConnString 	:= self:BuildConnectionString( cServer, cDatabaseName, cUser, cPassword, cRole )
	lReturn			:= self:Connect( cConnString )

	return lReturn

#endregion

end class

end namespace

