// Application : rdm.AdsSql
// AdsSqlConnection.prg , Created : 19.06.2018   09:29
// User : Wolfgang

using Advantage.Data.Provider
using System.Data
using System.Collections
using System.Diagnostics
using System.Collections.Generic
using XSharp.Tools.SQLBase

begin namespace XSharp.Tools.AdsSQL

class AdsSqlConnection inherit System.Object implements ISQLConnection, IDisposable
	protect _oConnection 			as AdsConnection
	protect _lConnected 			as logic
	protect _cLastError				as string
	protect _cTableType				as string
	protect _cCharType				as string
	protect _lTrimTrailingSpaces	as logic
	protect _oException				as Exception
	protect _cConnString			as string

#region constructors

constructor( cServer as string, cDatabaseName as string, cUser as string, cPassword as string )

	super()
    self:Initialize()
	self:OpenConnection( cServer, cDatabaseName, cUser, cPassword )

	return

constructor( cPath as string )

	super()
	self:Initialize()

	if cPath:Substring( 0, 2 ):ToUpper() == "C:"
		_cConnString				:= String.Format( "data source={0}; ServerType=local; TableType=CDX; TrimTrailingSpaces=true; CharType=OEM", cPath )
	else
		_cConnString				:= String.Format( "data source={0}; ServerType=remote; TableType=CDX; TrimTrailingSpaces=true; CharType=OEM", cPath )
	endif

    return

constructor()

    super()
    self:Initialize()

    return

method Initialize() as logic

	_cTableType				:= "CDX"
	_cCharType				:= "OEM"
	_lTrimTrailingSpaces	:= true

	return true

#endregion
#region public properties
public property Connection as AdsConnection get _oConnection
public property Connected as logic get _lConnected
public property ConnString as string get _cConnString
public property LastError as string get _cLastError
public property TableType as string  get _cTableType set _cTableType := value
public property CharType as string  get _cCharType set _cCharType := value
public property TrimTrailingSpaces as logic get _lTrimTrailingSpaces set _lTrimTrailingSpaces := value
public property Exception as Exception get _oException

#endregion
#region Public methods

method Dispose() as void

	if self:IsConnectionOpen()
		self:Close()
	endif

	return

public method BuildConnectionString( cServer as string, cDatabaseName as string, cUser as string, cPassword as string, cRole as string ) as string
	local cConnString			as string

	cConnString		:= AdsSqlHelper.BuildConnectionString( cServer, self:TableType, self:CharType, self:TrimTrailingSpaces )

	return cConnString

method Connect() as logic

	return self:Connect( _cConnString )

method Connect( cConnString as string ) as logic

    try

    _oConnection        			:= AdsConnection{}
    _oConnection:ConnectionString 	:= cConnString
    _oConnection:Open()
    _lConnected         			:= self:IsConnectionOpen()

    catch oEx as Exception

    _lConnected         			:= false
    _cLastError						:= oEx:Message
    _oException						:= oEx
    Debug.WriteLine( oEx:Message )
	ErrorSys.InvokeExceptionHandler( oEx, cConnString )

    end try

    return _lConnected

method IsConnectionOpen() as logic pascal
    local lReturn       as logic

    lReturn := false
    if _oConnection != null_object
        if _oConnection:State == ConnectionState.Open
            lReturn := true
        endif
    endif

    return lReturn

method ExecuteStatement( cStatement as string ) as int
    local oCommand      as AdsCommand
    local nReturn       as int

    oCommand        := AdsCommand{ cStatement, _oConnection }
    nReturn         := oCommand:ExecuteNonQuery()

    return nReturn

method Close() as void

   if _oConnection != null .and. _lConnected
       if _oConnection:State != ConnectionState.Closed .and. _oConnection:State != ConnectionState.Broken
       		try
           _oConnection:Close()
       		catch oEx as Exception
       			_oException		:= oEx
       		end try
       endif
       _oConnection         := null_object
       _lConnected          := false
   endif

return

method GetDataTable( cSelect as string ) as DataTable
	local oReader			as AdsDataReader
	local oDataTable		as DataTable
	local oCommand			as AdsCommand

    oDataTable          := null_object

	try

	oCommand				:= self:Connection:CreateCommand()
	oCommand:CommandText	:= cSelect
	oReader					:= oCommand:ExecuteReader()
	oDataTable				:= DataTable{}
	oDataTable:Load( oReader )
	oReader:Dispose()
	oCommand:Dispose()

	catch oEx as Exception

    _cLastError			:= oEx:Message
    Debug.WriteLine( oEx:Message )
    _oException			:= oEx
	ErrorSys.InvokeExceptionHandler( oEx, cSelect )

	end try

	return oDataTable

method OpenConnection( cServer as string, cDatabaseName as string, cUser as string, cPassword as string ) as logic
	local ConnString 	as string
	local lReturn		as logic

	ConnString 	:= self:BuildConnectionString( cServer, cDatabaseName, cUser, cPassword, "" )
	lReturn		:= self:Connect( ConnString )

	return lReturn

method OpenConnection( cServer as string, cDatabaseName as string, cUser as string, cPassword as string, cRole as string ) as logic
	local cConnString 	as string
	local lReturn		as logic

	cConnString 	:= self:BuildConnectionString( cServer, cDatabaseName, cUser, cPassword, cRole )
	lReturn			:= self:Connect( cConnString )

	return lReturn

method OpenConnection( cConnString as string ) as logic
	local lReturn		as logic

	lReturn			:= self:Connect( cConnString )

	return lReturn


#endregion

end class

end namespace

