/* ------------------------------------------------------------------------ */
/* WCLASS.LIB - Classes for Clipper 5.2/5.3                                 */
/*                                                                          */
/* (c) 1996-2004 by Wolfgang Riedmann wolfgang@riedmann.it                  */
/*                                                                          */
/* MSGBOXCL.PRG contains a messagebox class                                 */
/*                                                                          */
/* uses undocumented functions to create new classes in plain clipper code  */
/*                                                                          */
/* created 14/03/96                                                         */
/*                                                                          */
/* ------------------------------------------------------------------------ */

#include "inkey.ch"
#include "box.ch"
#include "setcurs.ch"
#include "common.ch"


#define CAPTION         1
#define MESSAGE         2
#define CHOICE          3
#define MCOLOR          4
#define RESULT          5


/* ----------------------------
* class function
*/
FUNCTION MsgBox( cCaption, aMsg, aChoices, cColor )

    STATIC nClassHandle
    LOCAL  oMsgBox

    IF nClassHandle == NIL
        nClassHandle    := __ClassNew( "WMSGBOX", 5 )
        InitMsgBoxClass( nClassHandle )
    ENDIF
    oMsgBox     := __ClassIns( nClassHandle )
    IF PCount() < 4 .OR. ValType( cColor ) != "C"
        cColor      := "N/W,W+/N,,,W+/W"
    ENDIF
    IF PCount() < 3 .OR. aChoices == NIL
        aChoices    := "OK"
    ENDIF

    oMsgBox:caption := cCaption
    oMsgBox:msg     := aMsg
    oMsgBox:choices := aChoices
    oMsgBox:color   := cColor
    oMsgBox:result  := 0

    RETURN oMsgBox



/* =================================================================== */
/* implementation of the class                                         */
/* =================================================================== */

/* ----------------------------
* initialization
*/
STATIC PROCEDURE InitMsgBoxClass( nHandle )

    // public instance vars
    __ClassAdd( nHandle, "msg", "_WRMMSG" )
    __ClassAdd( nHandle, "_msg", "_WRMMSG" )
    __ClassAdd( nHandle, "choices", "_WRMCHOICE" )
    __ClassAdd( nHandle, "_choices", "_WRMCHOICE" )
    __ClassAdd( nHandle, "color", "_WRMCOLOR" )
    __ClassAdd( nHandle, "_color", "_WRMCOLOR" )
    __ClassAdd( nHandle, "caption", "_WRMCAPTION" )
    __ClassAdd( nHandle, "_caption", "_WRMCAPTION" )
    __ClassAdd( nHandle, "result", "_WRMRESULT" )
    __ClassAdd( nHandle, "_result", "_WRMRESULT" )

    // methods
    __ClassAdd( nHandle, "show", "_WRMSHOW" )

    RETURN


/* ----------------------------
* Get/Set functions
*/
FUNCTION _WRMMSG( uValue )

    LOCAL nCounter, cType

    IF PCount() > 0
        IF ValType( uValue ) != "A"
            uValue      := { uValue }
        ENDIF
        FOR nCounter := 1 TO Len( uValue )
            cType   := ValType( uValue[nCounter] )
            DO CASE
            CASE cType == "N"
                uValue[nCounter]  := Str( uValue[nCounter] )
            CASE cType == "D"
                uValue[nCounter]  := DToC( uValue[nCounter] )
            CASE cType == "U"
                uValue[nCounter]  := "NIL"
            CASE cType == "M"
                uValue[nCounter]  := MemoLine( uValue[nCounter], MaxCol() - 6, 1 )
            CASE cType == "L"
                uValue[nCounter]  := IIf( uValue[nCounter], "TRUE", "FALSE" )
            CASE cType == "O"
                uValue[nCounter]  := "Object"
            CASE cType == "B"
                uValue[nCounter]  := "Block"
            ENDCASE
        END
        QSelf()[MESSAGE]  := uValue
    ENDIF

    RETURN IIf( PCount() > 0, QSelf(), QSelf()[MESSAGE] )

/* --------------------------- */
FUNCTION _WRMCAPTION( uValue )

    LOCAL cType

    IF PCount() > 0
        cType   := ValType( uValue )
        DO CASE
        CASE cType == "N"
            uValue  := Str( uValue )
        CASE cType == "D"
            uValue  := DToC( uValue )
        CASE cType == "U"
            uValue  := ""
        CASE cType == "M"
            uValue  := MemoLine( uValue, MaxCol() - 6, 1 )
        CASE cType == "L"
            uValue  := IIf( uValue, "TRUE", "FALSE" )
        CASE cType == "O"
            uValue  := "Object"
        CASE cType == "B"
            uValue  := "Block"
        CASE cType == "A"
            uValue  := "Array"
        CASE cType == "C"
            IF Len( uValue ) > ( MaxCol() - 5 )
                uValue    := Left( uValue, MaxCol() - 5 )
            ENDIF
        ENDCASE
        QSelf()[CAPTION]  := uValue
    ENDIF

    RETURN IIf( PCount() > 0, QSelf(), QSelf()[CAPTION] )

/* --------------------------- */
FUNCTION _WRMCHOICE( uValue )

    LOCAL nCounter

    IF PCount() > 0
        IF ValType( uValue ) == NIL
            uValue  := "[ OK ]"
        ENDIF
        IF ValType( uValue ) != "A"
            uValue  := { uValue }
        ENDIF
        FOR nCounter := 1 TO Len( uValue )
            IF ValType( uValue[nCounter] ) != "C"
                uValue[nCounter]    := "[ ?" + ValType( uValue[nCounter] ) + "? ]"
            ENDIF
        END
        QSelf()[CHOICE]  := uValue
    ENDIF

    RETURN IIf( PCount() > 0, QSelf(), QSelf()[CHOICE] )

/* --------------------------- */
FUNCTION _WRMCOLOR( uValue )

    IF PCount() > 0 .AND. ValType( uValue ) == "C"
        QSelf()[MCOLOR]  := uValue
    ENDIF

    RETURN IIf( PCount() > 0, QSelf(), QSelf()[MCOLOR] )

/* --------------------------- */
FUNCTION _WRMRESULT( uValue )

    IF PCount() > 0 .AND. ValType( uValue ) == "N"
        QSelf()[RESULT]  := uValue
    ENDIF

    RETURN IIf( PCount() > 0, QSelf(), QSelf()[RESULT] )


/* ----------------------------
* methods
*/
FUNCTION _WRMSHOW()

    LOCAL nKey, i, aBegin, aEnd, cInvColor
	LOCAL nStartRow, nEndRow, nStartCol, nEndCol
	LOCAL MaxAusw, BegAusw, nMouseRow, nMouseCol
    LOCAL nWide, oWindow, nButtonRow, nChoice
    LOCAL aChoices, aText, cColor, cCaption

    aChoices    := QSelf()[CHOICE]
    aText       := QSelf()[MESSAGE]
    cColor      := QSelf()[MCOLOR]
    cCaption    := QSelf()[CAPTION]
    CLEAR TYPEAHEAD
	nWide := 0
    aBegin  := {}
    aEnd    := {}
    BegAusw := 0
    FOR i := 1 TO Len( aChoices )
        aChoices[i] := StrTran( aChoices[i], "[" )
        aChoices[i] := StrTran( aChoices[i], "]" )
        aChoices[i] := StrTran( aChoices[i], "&" )
        aChoices[i] := "[ " + AllTrim( aChoices[i] ) + " ]"
        nWide += Len( aChoices[i] ) + 2
        IF ( nWide - 2 ) > ( MaxCol() - 3 )
            Alert( "choices don't fit" )
            ASize( aChoices, i - 1 )
            EXIT
        ENDIF
    END
    nWide -= 2
    BegAusw := Int( MaxCol() / 2 ) - Int( nWide / 2 )
    FOR i := 1 TO Len( aChoices )
        AAdd( aBegin, BegAusw )
        BegAusw += Len( aChoices[i] )
        AAdd( aEnd, BegAusw )
        BegAusw += 2
    END
 	IF LEN( aText ) > MAXROW() - 6
        Alert( "Too many message lines" )
        ASize( aText, MaxRow() - 6 )
 	ENDIF
    AEVAL( aText, { |Ausw| nWide := MAX( nWide, LEN( ALLTRIM( Ausw ) ) ) } )
	nStartCol := INT( ( MAXCOL() - nWide ) / 2 ) - 2
	nEndCol := INT( ( MAXCOL() + nWide ) / 2 ) + 1
	nStartRow := INT( ( MAXROW() - LEN( aText ) - 2 ) / 2 ) - 1
	nEndRow := nStartRow + LEN( aText ) + 3
    oWindow := Window( nStartRow, nStartCol, nEndRow + 1, nEndCol + 1 )
    oWindow:color   := cColor
    oWindow:box     := B_SINGLE
    oWindow:shadow  := .T.
    IF Len( cCaption ) > 0
        oWindow:title   := cCaption
    ENDIF
    oWindow:open()
    SETCURSOR( SC_NONE )
 	FOR i = 1 to LEN( aText )
 		TextCenter( ALLTRIM( aText[i] ), nStartRow + i )
 	NEXT
	nKey := 0
    nChoice := IIF( ISNUMBER( nChoice ) .and. nChoice > 0 .and. nChoice < LEN( aChoices ), ;
                  nChoice, 1 )
    cInvColor   := SUBSTR( cColor, AT( ",", cColor ) + 1 )
    nButtonRow  := nEndRow - 1
// Beginn Tastaturabfrage
 	WHILE (nKey != K_RETURN .and. nKey != K_ESC)
        FOR i := 1 TO Len( aChoices )
            IF i == nChoice
                @ nButtonRow, aBegin[i] SAY aChoices[i] COLOR cInvColor
            ELSE
                @ nButtonRow, aBegin[i] SAY aChoices[i] COLOR cColor
            ENDIF
        END
 		nKey := Inkey(0)
 		DO CASE
   	    CASE nChoice > 1 .and. ( nKey == K_LEFT .or. nKey == K_SH_TAB )
   		    nChoice--
   	    CASE nChoice < LEN( aChoices ) .and. ( nKey == K_RIGHT .or. nKey == K_TAB )
   		    nChoice++
   	    CASE nChoice == LEN( aChoices ) .and. nKey == K_TAB
   		    nChoice := 1
   	    CASE nChoice == 1 .and. nKey == K_SH_TAB
   		    nChoice := LEN( aChoices )
   	    CASE nKey == K_ESC
   		    nChoice := 0
#ifdef CLIP53
        CASE nKey == K_LBUTTONDOWN .OR. nKey == K_LDBLCLK
            nMouseRow   := MRow()
            nMouseCol   := MCol()
            // Cursor in Button-Zeile ?
            IF nMouseRow == nButtonRow
                FOR i := 1 TO Len( aChoices )
                    IF nMouseCol >= aBegin[i] .AND. nMouseCol < aEnd[i]
                        nChoice := i
                        nKey    := K_RETURN
                        EXIT
                    ENDIF
                END
            END
#endif
        END
    END
    oWindow:Close()
    QSelf()[RESULT] := nChoice

	RETURN( nChoice )



